<x-layouts.auth-layout>
    <div class="flex flex-col max-w-[960px] relative">

        {{-- Overlay de carga --}}
        <div id="loading-overlay"
            class="hidden absolute inset-0 bg-white/80 backdrop-blur-sm z-50 items-center justify-center flex-col space-y-4">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-primary200"></div>
            <p id="loading-text" class="text-complement300 text-size-subtitle font-medium">Enviando notificaciones...
            </p>
        </div>

        {{-- Mensaje de estado (éxito/error) --}}
        <div id="status-message"
            class="hidden border rounded-lg p-3 mb-4 text-sm font-medium transition-all duration-300"></div>

        {{-- Encabezado de acciones --}}
        <div class="py-4 sm:py-6 border-b border-[#dcdce5] flex justify-between items-center">
            <div class="flex items-center space-x-4">
                <span id="selected-count" class="text-complement300 text-size-subtitle font-roboto">0
                    seleccionadas</span>

                {{-- Botón anular selección --}}
                <x-controls.button id="clear-selection"
                    class="disabled:opacity-50 bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium px-4 py-2 rounded-lg transition"
                    disabled>
                    Anular selección
                </x-controls.button>
            </div>

            {{-- Botones de acción --}}
            <div class="flex space-x-3">
                <button id="send-email" data-action="email"
                    class="action-button flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition duration-150 ease-in-out disabled:opacity-50 disabled:cursor-not-allowed"
                    disabled>
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20"
                        fill="currentColor">
                        <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z" />
                        <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z" />
                    </svg>
                    Correo
                </button>

                <button id="send-whatsapp" data-action="whatsapp"
                    class="action-button flex items-center px-4 py-2 bg-green-500 hover:bg-green-600 text-white text-sm font-medium rounded-lg transition duration-150 ease-in-out disabled:opacity-50 disabled:cursor-not-allowed"
                    disabled>
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 24 24"
                        fill="currentColor">
                        <path
                            d="M12 2C6.477 2 2 6.477 2 12c0 3.313 1.543 6.309 4.02 8.286l-.75 2.714 2.822-.76a9.927 9.927 0 005.894 1.408c5.523 0 10-4.477 10-10S17.523 2 12 2zm4.8 14.5c-.173.284-.664.577-1.127.643-.463.066-.992.052-1.5-.138-.636-.246-1.984-.813-2.316-.94-.332-.127-.565-.187-.803.18-.238.367-.925 1.13-1.13 1.365-.205.235-.407.252-.756.09-.349-.16-.628-.242-1.196-.45-1.936-1.282-2.924-3.047-3.268-3.614-.345-.567-.037-.872.285-1.16.284-.257.625-.43.834-.637.208-.207.309-.36.417-.597.108-.237.054-.447-.027-.636-.081-.19-.72-.19-.94-.197-.22-.007-.48.064-.73.34-.25.276-.94.925-.94 2.27s.96 2.637 1.08 2.827c.12.19.86 1.487 2.083 2.073 1.222.586 2.285.836 2.915.93.63.094 1.42.062 1.957-.278.537-.34.93-.82 1.18-.87.25-.05.545-.008.74.053.195.06.414.28.53.468.116.188.116.35.035.539z" />
                    </svg>
                    WhatsApp
                </button>
            </div>
        </div>

        {{-- Lista de invitados --}}
        <div id="notification-list" class="divide-y divide-complement300">
            <label for="select-all"
                class="flex items-center py-4 sm:py-6 cursor-pointer transition duration-150 ease-in-out">
                <input type="checkbox" id="select-all"
                    class="h-5 w-5 rounded border-[#dde1e3] border-2 bg-transparent focus:ring-0">
                <span class="ml-4 font-roboto text-parrafo">Seleccionar todos</span>
            </label>

            @foreach($guests as $guest)
                <label for="guest-{{ $guest->id }}"
                    class="flex items-center py-4 sm:py-6 cursor-pointer transition duration-150 ease-in-out">
                    <input type="checkbox" id="guest-{{ $guest->id }}" data-id="{{ $guest->id }}"
                        class="guest-checkbox form-checkbox h-5 w-5 text-blue-500 rounded border-gray-600 bg-gray-700 focus:ring-blue-500">
                    <div class="ml-4 flex-1 overflow-hidden">
                        <p class="text-parrafo font-semibold truncate">{{ $guest->name }}</p>
                    </div>
                </label>
            @endforeach
        </div>
    </div>
    @push('scripts')
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const selectAllCheckbox = document.getElementById('select-all');
                const guestCheckboxes = document.querySelectorAll('.guest-checkbox');
                const actionButtons = document.querySelectorAll('.action-button');
                const selectedCountSpan = document.getElementById('selected-count');
                const clearSelectionButton = document.getElementById('clear-selection');
                const statusMessageDiv = document.getElementById('status-message');
                const loadingOverlay = document.getElementById('loading-overlay');
                const loadingText = document.getElementById('loading-text');

                const routePath = @json(route('organizer.notifications.send', [], false)).replace(/^\//, '');
                const apiUrl = '/' + routePath;
                const getCsrfToken = () => {
                    return document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                };

                /**
                 * Actualiza el contador y activa/desactiva los botones según selección
                 */
                const updateUI = () => {
                    const selectedCount = document.querySelectorAll('.guest-checkbox:checked').length;
                    selectedCountSpan.textContent = `${selectedCount} seleccionada${selectedCount !== 1 ? 's' : ''}`;

                    const isProcessing = loadingOverlay?.classList.contains('flex');
                    const hasSelection = selectedCount > 0 && !isProcessing;

                    // Habilitar o deshabilitar los botones de acción (Correo / WhatsApp)
                    actionButtons.forEach(button => {
                        button.disabled = !hasSelection;
                    });

                    // Habilitar o deshabilitar el botón "Anular selección"
                    clearSelectionButton.disabled = !hasSelection;

                    // Mostrar u ocultar el botón de anular
                    clearSelectionButton.style.display = hasSelection ? 'inline-flex' : 'none';

                    // Estado del checkbox "Seleccionar todos"
                    const allSelected = selectedCount > 0 && selectedCount === guestCheckboxes.length;
                    selectAllCheckbox.checked = allSelected;
                    selectAllCheckbox.indeterminate = selectedCount > 0 && !allSelected;
                    selectAllCheckbox.disabled = !!isProcessing;
                };

                const showStatus = (message, isSuccess) => {
                    statusMessageDiv.textContent = message;
                    statusMessageDiv.classList.remove('hidden', 'bg-red-200', 'text-red-800', 'bg-green-200', 'text-green-800');
                    statusMessageDiv.classList.add(isSuccess ? 'bg-green-200' : 'bg-red-200', isSuccess ? 'text-green-800' : 'text-red-800');
                    setTimeout(() => statusMessageDiv.classList.add('hidden'), 5000);
                };

                const toggleLoading = (isLoading, actionType = '') => {
                    if (isLoading) {
                        loadingOverlay.classList.remove('hidden');
                        loadingOverlay.classList.add('flex');
                        loadingText.textContent = `Enviando notificaciones por ${actionType === 'whatsapp' ? 'WhatsApp' : 'Correo'}...`;
                    } else {
                        loadingOverlay.classList.remove('flex');
                        loadingOverlay.classList.add('hidden');
                    }
                    updateUI();
                };

                // --- EVENTOS ---
                selectAllCheckbox.addEventListener('change', (e) => {
                    guestCheckboxes.forEach(cb => cb.checked = e.target.checked);
                    updateUI();
                });

                guestCheckboxes.forEach(cb => {
                    cb.addEventListener('change', updateUI);
                });

                clearSelectionButton.addEventListener('click', () => {
                    guestCheckboxes.forEach(cb => cb.checked = false);
                    updateUI();
                });

                actionButtons.forEach(button => {
                    button.addEventListener('click', async (e) => {
                        e.preventDefault();
                        const actionType = e.currentTarget.dataset.action;
                        const selectedIds = Array.from(document.querySelectorAll('.guest-checkbox:checked'))
                            .map(cb => parseInt(cb.dataset.id));

                        if (selectedIds.length === 0) {
                            showStatus('Por favor, selecciona al menos un invitado.', false);
                            return;
                        }

                        toggleLoading(true, actionType);
                        try {
                            const response = await fetch("{{ route('organizer.notifications.send') }}", {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json',
                                    "Accept": "application/json",
                                    'X-CSRF-TOKEN': getCsrfToken(),
                                },
                                body: JSON.stringify({ guest_ids: selectedIds, action_type: actionType })
                            });

                            const result = await response.json();

                            if (response.ok) {
                                // Mostramos mensaje de éxito parcial si hay fallos
                                const failCount = result.details?.fail_count || 0;
                                const total = result.details?.total_guests || selectedIds.length;
                                const successCount = total - failCount;

                                const msg = failCount > 0
                                    ? `Notificaciones enviadas: ${successCount} exitosas, ${failCount} fallidas.`
                                    : `Todas las notificaciones se enviaron correctamente (${successCount}).`;

                                showStatus(msg, failCount === 0);
                                guestCheckboxes.forEach(cb => cb.checked = false);
                            } else if (response.status === 422 && result.message) {
                                // Error de backend
                                const failCount = result.details?.fail_count || 0;
                                const total = result.details?.total_guests || selectedIds.length;
                                const msg = failCount > 0
                                    ? `${result.message} ${failCount} de ${total} fallidas.`
                                    : result.message;
                                showStatus(msg, false);
                            } else {
                                showStatus(result.message || `Error al enviar: ${response.statusText}`, false);
                            }
                        } catch (error) {
                            showStatus('Lo sentimos, tuvimos un problema al enviar.', false);
                        } finally {
                            toggleLoading(false);
                        }
                    });
                });

                updateUI();
            });
        </script>
    @endpush

</x-layouts.auth-layout>