<x-layouts.auth-layout>
    <div class="flex flex-col max-w-[640px]">
        <form action="{{ route('organizer.guests.update', $guest->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="flex flex-wrap justify-between gap-3 py-4">
                <h2 class="text-complement300 font-roboto text-size-subtitle font-medium">Editar invitado</h2>
            </div>
            <x-controls.error-main />
            <x-controls.validation-errors />
            {{-- Nombre --}}
            <x-controls.input type="text" name="name" placeholder="Nombre completo" label="Nombre"
                value="{{ old('name', $guest->name) }}" required autofocus />

            {{-- Teléfono --}}
            <x-controls.input id="phone" type="tel" name="phone_number" placeholder="" label="Teléfono"
                value="{{ old('phone', $guest->phone) }}" required autofocus />

            {{-- Correo --}}
            <x-controls.input type="email" name="email" placeholder="Correo electrónico" label="Correo electrónico"
                value="{{ old('email', $guest->email) }}" required autofocus />
            {{-- Número máximo de invitados --}}
            <x-controls.input type="number" name="max_guests" placeholder="Número máximo de invitados permitidos"
                label="Invitados permitidos" value="{{ old('max_guests', $guest->max_guests) }}" min="1" required />
            {{-- Botones --}}
            <div class="flex gap-4 mt-8">
                <x-controls.button type="submit">Actualizar</x-controls.button>
                <x-controls.button href="{{ route('organizer.guests.index') }}" variant="secondary">
                    Cancelar
                </x-controls.button>
            </div>
        </form>
    </div>
    @push('scripts')
        <script>
            document.addEventListener("DOMContentLoaded", function () {
                const input = document.querySelector("#phone");
                window.intlTelInput(input, {
                    initialCountry: "mx",
                    separateDialCode: true,
                    strictMode: true,
                    nationalMode: true,
                    hiddenInput: () => ({ phone: "phone", country: "country_code" }),
                    loadUtils: () => import("https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/utils.js"),
                });
            });
        </script>
    @endpush
</x-layouts.auth-layout>