<div class="overflow-x-auto overflow-y-hidden rounded-xl border border-[#dde1e3] bg-white">
    <table class="min-w-full">
        <thead>
            <tr class="bg-white">
                @foreach ($columns as $column)
                    <th class="px-4 py-3 text-left text-[#121416] w-[{{ $column['width'] ?? 'auto' }}] text-sm font-medium leading-normal">
                        {{ $column['label'] }}
                    </th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @forelse ($items as $item)
                <tr class="border-t border-t-[#dde1e3]">
                    @foreach ($columns as $column)
                        <td class="h-[72px] px-4 py-2 w-[{{ $column['width'] ?? 'auto' }}] text-[#6a7681] text-sm font-normal leading-normal">
                            {!! $column['render']($item) !!}
                        </td>
                    @endforeach
                </tr>
            @empty
                <tr>
                    <td colspan="{{ count($columns) }}" class="text-center py-4 text-[#6a7681]">
                        No hay registros disponibles.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>

    @if ($items->hasPages())
        <div class="px-4 py-4">
            {{ $items->withQueryString()->links() }}
        </div>
    @endif
</div>