@props([
    'label' => '',
    'name' => '',
    'placeholder' => '',
    'value' => null,
    'variant' => 'primary',
])

@php
    // Resolver el contenido del textarea
    $content = old($name, $value);
@endphp

@php
    // Paleta por variante
    $palette = [
        'primary'   => 'input-primary',
        'secondary'   => 'input-secondary',
    ][$variant] ?? '';
@endphp

<label {{ $attributes->merge(['class' => "input-main $palette"]) }}>
    @if ($label)
        <p class="label">
            {{ $label }}
        </p>
    @endif
    <textarea name="{{ $name }}" placeholder="{{ $placeholder }}">{{ $content }}</textarea>

    @error($name)
        <span class="text-red-500 text-sm mt-2 block">{{ $message }}</span>
    @enderror
</label>