@props([
    'label' => '',
    'name' => '',
    'id' => '',
    'value' => '',
    'type' => 'text',
    'required' => false,
    'autofocus' => false,
    'disabled' => false,
    'placeholder' => '',
    'variant' => 'primary',
    'autocomplete' => 'on',
])

@php
    // Paleta por variante
    $palette = [
        'primary'   => 'input-primary',
        'secondary'   => 'input-secondary',
    ][$variant] ?? '';
@endphp

<label {{ $attributes->merge(['class' => "input-main $palette"]) }}>
    <p class="label">{{ $label }}</p>
    <input type="{{ $type }}" id="{{ $id }}" name="{{ $name }}" autocomplete="{{ $autocomplete }}" @if ($autofocus) autofocus @endif @if ($disabled) disabled @endif placeholder="{{ $placeholder }}"
        class="form-input"
        value="{{ old($name, $value) }}" />
    @error($name)
        <span class="text-red-500 text-sm mt-2 block">{{ $message }}</span>
    @enderror
</label>