<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class RolesAndAdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $adminRole = Role::firstOrCreate(['name' => 'admin'], ['display_name' => 'Administrador']);
        $organizerRole = Role::firstOrCreate(['name' => 'organizer'], ['display_name' => 'Organizador']);

        $admin = User::firstOrCreate(
            ['email' => 'canalla.agency@gmail.com'],
            [
                'name' => 'Administrador',
                'password' => Hash::make('@#AdminDev2024#')
            ]
        );

        $organizer = User::firstOrCreate(
            ['email' => 'aldair.canalla.agency@gmail.com'],
            [
                'name' => 'Aldair Reyes Sánchez',
                'password' => Hash::make('aldair123')
            ]
        );

        $admin->roles()->syncWithoutDetaching([$adminRole->id]);

        $organizer->roles()->syncWithoutDetaching([$organizerRole->id]);
    }
}
