<?php
namespace App\Services;

use App\DTOs\Guest\RsvpDto;
use App\Models\Guest;
use App\Models\Rsvp;
use Illuminate\Support\Facades\Log;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Exception;

class RsvpService
{
    public function getPaginated(int $perPage = 10): LengthAwarePaginator
    {
        return Rsvp::with('guest')
            ->orderByDesc('confirmed_at')
            ->paginate($perPage);
    }

    public function getCountConfirmation(): int
    {
        return Rsvp::where('attendance', '=', 'yes')->count();
    }

    public function existsConfirmationByGuest(int $guestId): bool
    {
        return Rsvp::where("guest_id", $guestId)->exists();
    }

    public function confirm(RsvpDto $dto, int $guestId): ?Rsvp
    {
        try {
            $rsvp = Rsvp::create([
                'guest_id' => $guestId,
                'attendance' => $dto->attendance,
                'dietary_restrictions' => $dto->dietary_restrictions,
                'comments' => $dto->comments,
                'confirmed_guests' => $dto->guest_count,
                'confirmed_at' => now(),
            ]);
            return $rsvp;
        } catch (Exception $e) {
            Log::error('Error al confirmar RSVP: ' . $e->getMessage(), [
                'data' => (array) $dto,
                'trace' => $e->getTraceAsString(),
            ]);
            return null;
        }
    }
}