<?php

namespace App\Http\Controllers\Organizer;

use App\Http\Controllers\Controller;
use App\Http\Requests\Organizer\SendNotificationsRequest;
use App\Services\GuestService;
use App\Services\NotificationService;
use Illuminate\Http\JsonResponse;

class NotificationController extends Controller
{

    public function __construct(protected GuestService $guestService, protected NotificationService $notificationService)
    {
    }

    public function index()
    {
        $guests = $this->guestService->getAll();
        return view('organizer.notifications.index', compact('guests'));
    }

    public function sendNotifications(SendNotificationsRequest $request): JsonResponse
    {
        $validated = $request->validated();

        // Puedes acceder a los datos así:
        $guestIds = $validated['guest_ids'];
        $action = $validated['action_type'];

        $listGuests = $this->guestService->getByIds($guestIds);
        $results = $this->notificationService->sendBulkNotification($listGuests, $action);

        if (isset($results['error'])) {
            return response()->json([
                'message' => $results['error'],
            ], 422);
        }
        $data = $results[$action];
        if ($data['fail_count'] === $data['total_guests']) {
            return response()->json([
                'message' => 'No se pudieron enviar las notificaciones.',
                'details' => $data,
            ], 422);
        }

        return response()->json([
            'total_guests' => count($guestIds),
            'success_count' => $results[$action]['success_count'] ?? 0,
            'fail_count' => $results[$action]['fail_count'] ?? 0,
            'details' => $results[$action] ?? [],
        ]);
    }
}