<?php

namespace App\Channels;

use App\Interfaces\NotificationChannel;
use App\Models\Guest;
use Twilio\Rest\Client;
use Illuminate\Support\Facades\Log;

class WhatsAppChannel implements NotificationChannel
{
    protected Client $twilio;
    protected string $fromNumber;

    public function __construct(Client $twilio)
    {
        $this->twilio = $twilio;
        $this->fromNumber = config('services.twilio.whatsapp_from');
    }

    /**
     * Envía un mensaje de WhatsApp al invitado.
     */
    public function send(Guest $guest): bool
    {
        try {
            if (empty($guest->phone)) {
                Log::warning("El invitado {$guest->name} no tiene número de teléfono.");
                return false;
            }

            $to = 'whatsapp:' . $guest->phone;

            $url = route('home', ['guest' => $guest->slug]);
            $nameGuest = $guest->name;
            // $message = "Hola {$guest->name}! Nos encantaría que nos acompañaras en nuestro día especial.Confirma tu asistencia aquí {$url}";

            $this->twilio->messages->create($to, [
                'messagingServiceSid' => config('services.twilio.services_id'),
                'contentSid' => config('services.twilio.whatsapp_template_id'),
                'contentVariables' => json_encode([
                    '1' => $nameGuest,
                    '2' => $url
                ]),
                'from' => $this->fromNumber,
            ]);

            Log::info("WhatsApp enviado a {$guest->name} ({$guest->phone}) con éxito.");
            return true;
        } catch (\Throwable $e) {
            Log::error("Error enviando WhatsApp a {$guest->name}: " . $e->getMessage());
            return false;
        }
    }
}